AutomaticDrinkingTrough = {}
AutomaticDrinkingTrough.isDebugMode = false

function debugMsg(debugMessage)
    if AutomaticDrinkingTrough.isDebugMode ~= nil and AutomaticDrinkingTrough.isDebugMode then
        print("[AutomaticDrinkingTrough] --> " .. debugMessage)
    end
end

function checkForWater()
    for _, placeable in ipairs(g_currentMission.husbandrySystem.placeables) do
        if placeable.configFileNameClean ~= nil then
            if placeable.configFileNameClean == "cowBarnSmall" or placeable.configFileNameClean == "horseBarnSmall" or placeable.configFileNameClean == "pigBarnSmall" or placeable.configFileNameClean == "sheepBarnSmall" then
                if placeable:getNumOfAnimals() > 0 then
                    local waterAmount = placeable.spec_husbandry.storage:getFreeCapacity(FillType.WATER, true)
                    local waterPrice = g_fillTypeManager:getFillTypeByIndex(FillType.WATER).pricePerLiter * waterAmount
                    local farm = g_farmManager:getFarmById(placeable.ownerFarmId)
                    if farm ~= nil then
                        if farm:getBalance() - waterPrice > 0 then
                            placeable.spec_husbandry.storage:setFillLevel(placeable.spec_husbandry.storage:getFillLevel(FillType.WATER) + waterAmount, FillType.WATER)
                            g_currentMission:addMoney(-waterPrice, placeable.ownerFarmId, MoneyType.PURCHASE_WATER, false)
                        end
                    end
                end
            end
        end
    end
end

function AutomaticDrinkingTrough:hourChanged()
	if g_currentMission.environment.currentHour == 10 then
		checkForWater()
    else
        return
	end
end

function AutomaticDrinkingTrough:loadMap(mapFilename)
	if g_currentMission:getIsServer() then
		g_messageCenter:subscribe(MessageType.HOUR_CHANGED, self.hourChanged, self)
	end
end

function AutomaticDrinkingTrough:deleteMap()
	if g_currentMission:getIsServer() then
		g_messageCenter:unsubscribe(MessageType.HOUR_CHANGED, self)
	end
end

addModEventListener(AutomaticDrinkingTrough)