FieldLeasingManager = {}
local FieldLeasingManager_mt = Class(FieldLeasingManager, AbstractManager)

FieldLeasingManager.priceMultiplier = 1.0
FieldLeasingManager.minDuration = 12

function FieldLeasingManager.new(customMt)
	self = AbstractManager.new(customMt or FieldLeasingManager_mt)

    self.fieldLeaseAgreements = {}
    self.priceMultiplier = FieldLeasingManager.priceMultiplier
    self.minDuration = FieldLeasingManager.minDuration

    g_messageCenter:subscribe(MessageType.PERIOD_CHANGED, self.onPeriodChanged, self)

    return self
end

function FieldLeasingManager:lease(farmlandId, farmId, price)
	local farmlandOwner = g_farmlandManager:getFarmlandOwner(farmlandId)
    g_farmlandManager:setLandOwnership(farmlandId, farmId)
    if farmlandOwner ~= FarmlandManager.NO_OWNER_FARM_ID then
        g_messageCenter:publish(MessageType.FARM_PROPERTY_CHANGED, farmlandOwner)
    end
    if farmId ~= FarmlandManager.NO_OWNER_FARM_ID then
        g_messageCenter:publish(MessageType.FARM_PROPERTY_CHANGED, farmId)
    end

    if not g_currentMission:getIsServer() then
        return
    end

    local fieldLeaseAgreement = FieldLeaseAgreement.new(g_currentMission:getIsServer(), g_currentMission:getIsClient())

    fieldLeaseAgreement.farmlandId = farmlandId
    fieldLeaseAgreement.farmId = farmId
    fieldLeaseAgreement.price = price
    fieldLeaseAgreement.duration = 0
    fieldLeaseAgreement:register()

    self.fieldLeaseAgreements[farmlandId] = fieldLeaseAgreement
end

function FieldLeasingManager:terminateLease(farmlandId, farmId)
	local farmlandOwner = g_farmlandManager:getFarmlandOwner(farmlandId)
    g_farmlandManager:setLandOwnership(farmlandId, farmId)
    if farmlandOwner ~= FarmlandManager.NO_OWNER_FARM_ID then
        g_messageCenter:publish(MessageType.FARM_PROPERTY_CHANGED, farmlandOwner)
    end
    if farmId ~= FarmlandManager.NO_OWNER_FARM_ID then
        g_messageCenter:publish(MessageType.FARM_PROPERTY_CHANGED, farmId)
    end
    local fieldLeaseAgreement = self.fieldLeaseAgreements[farmlandId]
    if fieldLeaseAgreement ~= nil then
        fieldLeaseAgreement:delete()
    end
    self.fieldLeaseAgreements[farmlandId] = nil
end

function FieldLeasingManager:onPeriodChanged()
    if not g_currentMission:getIsServer() then
        return
    end

    for _, leaseAgreement in pairs(self.fieldLeaseAgreements) do
        g_currentMission:addMoney(-leaseAgreement.price * self:getPriceMultiplier(), leaseAgreement.farmId, MoneyType.FIELD_LEASE, true, true)
        leaseAgreement:updateDuration()
    end
end

function FieldLeasingManager:priceForFarmland(farmlandId)
    local farmland = g_farmlandManager:getFarmlandById(farmlandId)
    return farmland.price * self:getPriceMultiplier()
end

function FieldLeasingManager:getPriceMultiplier()
    return (self.priceMultiplier / 100) / 12
end

function FieldLeasingManager:getLeaseAgreement(farmlandId)
    return self.fieldLeaseAgreements[farmlandId]
end

function FieldLeasingManager:updatePriceMultiplier(multiplier, noEventSend)
    if multiplier == self.priceMultiplier then
        return
    end

    self.priceMultiplier = multiplier
    FieldLeasingSettingsEvent.sendEvent(noEventSend)
end

function FieldLeasingManager:updateMinDuration(minDuration, noEventSend)
    if minDuration == self.minDuration then
        return
    end

    self.minDuration = minDuration
    FieldLeasingSettingsEvent.sendEvent(noEventSend)
end

function FieldLeasingManager.saveToXMLFile()
    local savegameDirectory = g_currentMission.missionInfo.savegameDirectory

    if savegameDirectory ~= nil then
        local saveGamePath = savegameDirectory.."/fieldLeasingAgreements.xml"
        local key = "fieldLeasingAgreements"
        local xmlFile = XMLFile.create("fieldLeasingAgreements", saveGamePath, key)

        if xmlFile ~= nil then
            xmlFile:setFloat(key.."#priceMultiplier", g_fieldLeasingManager.priceMultiplier)
            xmlFile:setInt(key.."#minDuration", g_fieldLeasingManager.minDuration)

            local index = 0
            for _, fieldLeaseAgreement in pairs(g_fieldLeasingManager.fieldLeaseAgreements) do
                local fieldLeaseAgreementKey = string.format(key..".fieldLeaseAgreement(%d)", index)
                fieldLeaseAgreement:saveToXMLFile(xmlFile, fieldLeaseAgreementKey)
                index = index + 1
            end

            xmlFile:save()
            xmlFile:delete()
        end
    end
end

FSCareerMissionInfo.saveToXMLFile = Utils.appendedFunction(FSCareerMissionInfo.saveToXMLFile, FieldLeasingManager.saveToXMLFile)

function FieldLeasingManager.loadFromXMLFile()
    local savegameDirectory = g_currentMission.missionInfo.savegameDirectory

    if savegameDirectory ~= nil then
        local filename = savegameDirectory.."/fieldLeasingAgreements.xml"
        local key = "fieldLeasingAgreements"
        local xmlFile = XMLFile.loadIfExists("fieldLeasingAgreements", filename, key)

        if xmlFile ~= nil then
            g_fieldLeasingManager.priceMultiplier = xmlFile:getFloat(key.."#priceMultiplier", FieldLeasingManager.priceMultiplier)
            g_fieldLeasingManager.minDuration = xmlFile:getInt(key.."#minDuration", FieldLeasingManager.minDuration)

            local index = 0
            while true do
                local fieldLeaseAgreementKey = string.format(key..".fieldLeaseAgreement(%d)", index)

                if not xmlFile:hasProperty(fieldLeaseAgreementKey) then
                    break
                end

                local fieldLeaseAgreement = FieldLeaseAgreement.new(true, g_client ~= nil)
                if fieldLeaseAgreement:loadFromXMLFile(xmlFile, fieldLeaseAgreementKey) then
                    fieldLeaseAgreement:register()
                    g_fieldLeasingManager.fieldLeaseAgreements[fieldLeaseAgreement.farmlandId] = fieldLeaseAgreement
                else
                    fieldLeaseAgreement:delete()
                end

                index = index + 1
            end
            xmlFile:delete()
        end
    end
end

Mission00.loadItemsFinished = Utils.appendedFunction(Mission00.loadItemsFinished, FieldLeasingManager.loadFromXMLFile)

g_fieldLeasingManager = FieldLeasingManager.new()